function UpdatePlot(handles,modus)
% The Image update process is separated into three parts to speed up
% things:
% 1. Update Plot
% 2. UpdateImage
% 3. PlotImg
% UpdatePlot switches between Original Data, Denoised, Deconvolved and
% Substrate Deconvolved. Then passes the data throu to 2. UpdateImage

if nargin<2
    modus = get(handles.DecEELS,'UserData');
end
RemZLP    =            get(handles.RemZLP,'Value');
NormImg   =            get(handles.NormImg,'Value');
ContVal   = str2double(get(handles.ContVal,'String'));
Axis      =            get(handles.Load,'UserData');

fit       = load(fullfile(tempdir,'SubtrZLP.mat')).Data;
Fit       = fit{1};

if (~isempty(Fit)) && (modus==0 || modus==1)
    set(handles.RemZLP,'Visible','On')
else
    set(handles.RemZLP,'Visible','Off')
end

Zoom      = get(handles.Zoom,'UserData');

%% Load Files
if modus==0
    image    = load(fullfile(tempdir,'ShowOrg.mat')).image;
    Norm     = sum(image,3);
    if RemZLP==1 && ~isempty(Fit)
        image = image - Fit(:,:,1:size(image,3));
        image(image<0)=0;
    end
elseif modus==1
    image   = load(fullfile(tempdir,'ShowDen.mat')).DenImg;
    Norm    = get(handles.ShowInt,'UserData');
    if RemZLP==1 && ~isempty(Fit)
        img   = load(fullfile(tempdir,'ShowOrg.mat')).image;
        norm     = repmat(Norm./sum(img,3),[1,1,size(image,3)]);
        image = image - Fit(:,:,1:size(image,3)).*norm;
        image(image<0)=0;
    end
elseif modus==2
    image    = load(fullfile(tempdir,'ShowDeconv.mat')).DeconvImg;
    Norm     = get(handles.ShowInt,'UserData');
elseif modus==3
    image    = load(fullfile(tempdir,'ShowDecSub.mat')).DeconvImg;
    Norm     = get(handles.ShowInt,'UserData');
end

if isempty(image)
    UpdatePlot(handles);
    return
end

Image      = image(Zoom(2):Zoom(4),Zoom(1):Zoom(3),:);
ScaleY     = Axis(1);
ScaleX     = Axis(2);
XMax       = ScaleX*size(Image,2)/2;
YMax       = ScaleY*size(Image,1)/2;
AxisX      = linspace(-XMax,XMax,size(Image,2));
AxisY      = linspace(YMax,-YMax,size(Image,1));
norm       = Norm(Zoom(2):Zoom(4),Zoom(1):Zoom(3));
if NormImg==1
    Image  = Image ./ norm;
end

BW         = imbinarize(Norm,mean(Norm,'all')*ContVal);
B          = bwboundaries(BW,'holes');

B1         = B{1};
Cont1       = B1-circshift(B1,-1,1);
Cont2       = B1-circshift(B1,1,1);
a=0;
for i=1:size(Cont1,1)
    Log        =((B1(i,1)==1 || B1(i,1)==size(image,1)) && abs(Cont1(i,2))== 1 && abs(Cont2(i,2))== 1) || ((B1(i,2)==1 || B1(i,2)==size(image,2)) && abs(Cont1(i,1))== 1 && abs(Cont1(i,1))== 1);
    if Log || i==size(Cont1,1) || i==1
        B{1}(i-a,:)=[];
        a=a+1;
    end
end

for k = 1:length(B)
    boundary = B{k};
    boundary(:,2) =  (boundary(:,2) - Zoom(1)-(Zoom(3)-Zoom(1))/2)*ScaleX;
    boundary(:,1) = -(boundary(:,1) - Zoom(2)-(Zoom(4)-Zoom(2))/2)*ScaleY;
    B{k} = boundary;
end


Data       = {Image,B,AxisX,AxisY};

%% Create Images
set(handles.DecEELS,'UserData',modus);
set(handles.CAxisMin,'UserData',Data);
UpdateImage(handles)

clearvars all
end